/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.jobs;

import com.badlogic.gdx.math.GridPoint2;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import technology.rocketjump.undermount.jobs.ProfessionDictionary;
import technology.rocketjump.undermount.jobs.model.Job;
import technology.rocketjump.undermount.jobs.model.JobCollection;
import technology.rocketjump.undermount.jobs.model.JobState;

@Singleton
public class JobStore {
    private final ProfessionDictionary professionDictionary;
    private Map<JobState, JobCollection> byState = new ConcurrentHashMap<JobState, JobCollection>();
    private Map<GridPoint2, List<Job>> byLocation = new ConcurrentHashMap<GridPoint2, List<Job>>();
    private Map<Long, Job> allJobs = new ConcurrentHashMap<Long, Job>();
    private static final List<Job> emptyList = new LinkedList<Job>();

    @Inject
    public JobStore(ProfessionDictionary professionDictionary) {
        this.professionDictionary = professionDictionary;
        for (JobState jobState : JobState.values()) {
            this.byState.put(jobState, new JobCollection(jobState, professionDictionary));
        }
    }

    public JobCollection getCollectionByState(JobState jobState) {
        return this.byState.get((Object)jobState);
    }

    public void addNewJob(Job job) {
        this.byState.get((Object)job.getJobState()).add(job);
        this.allJobs.put(job.getJobId(), job);
        GridPoint2 jobLocation = job.getJobLocation();
        List<Job> jobsAtLocation = this.byLocation.get(jobLocation);
        if (jobsAtLocation == null) {
            jobsAtLocation = new ArrayList<Job>();
            this.byLocation.put(jobLocation, jobsAtLocation);
        }
        jobsAtLocation.add(job);
    }

    public List<Job> getJobsAtLocation(GridPoint2 location) {
        List<Job> jobs = this.byLocation.get(location);
        if (jobs == null) {
            return emptyList;
        }
        return jobs;
    }

    public void remove(Job jobToRemove) {
        this.byState.get((Object)jobToRemove.getJobState()).remove(jobToRemove);
        this.getJobsAtLocation(jobToRemove.getJobLocation()).remove(jobToRemove);
        this.allJobs.remove(jobToRemove.getJobId());
        jobToRemove.setJobState(JobState.INACCESSIBLE);
        jobToRemove.setAssignedToEntityId(-1L);
    }

    public void switchState(Job job, JobState targetState) {
        JobCollection inState;
        JobState currentState = job.getJobState();
        if (targetState.equals((Object)JobState.PROCESSING_ACCESSIBILITY) && (inState = this.getCollectionByState(JobState.PROCESSING_ACCESSIBILITY)).size() > 0) {
            System.out.println("Now " + inState.size() + " jobs in " + (Object)((Object)JobState.PROCESSING_ACCESSIBILITY));
        }
        if (!currentState.equals((Object)targetState)) {
            this.byState.get((Object)currentState).remove(job);
            this.byState.get((Object)targetState).add(job);
        }
    }

    public void clear() {
        for (JobState jobState : JobState.values()) {
            this.byState.put(jobState, new JobCollection(jobState, this.professionDictionary));
        }
        this.byLocation.clear();
        this.allJobs.clear();
    }

    public Map<Long, Job> getAllJobs() {
        return this.allJobs;
    }
}

